<?php if (!defined('ABSPATH')) {
    die('Direct access forbidden.');
}

class Brizy_Editor_CompiledHtml
{

    /**
     * @var Brizy_Editor_Helper_Dom
     */
    private $dom;

    /**
     * Brizy_Editor_CompiledHtml constructor.
     *
     * @param $content
     */
    public function __construct($content)
    {
        $this->dom  = new Brizy_Editor_Helper_Dom($content);
    }

    /**
     * @return string
     * @deprecated Use getBody()
     */
    public function get_body()
    {
        return $this->getBody();
    }

    /**
     * @return string
     */
    public function getBody()
    {
        $body_tag = $this->dom->get_body();
        return $body_tag->get_content();
    }

    /**
     * @param bool $include_parent_tag
     *
     * @return string
     * @deprecated Use getHead)
     */
    public function get_head($include_parent_tag = false)
    {
        return $this->getHead($include_parent_tag);
    }

    /**
     * @param false $include_parent_tag
     * @return string
     */
    public function getHead($include_parent_tag = false)
    {
        $head_tag = $this->dom->get_head();
        return $head_tag->get_content();
    }

    /**
     * Extract the page content.. excluding headers and footers generated by Brizy
     *
     * This function will only remove headers added by Brizy.. if you want to remove some specific parts of the
     * content please use the `brizy_exclude_from_page_content` filter to add selectors that will be removed.
     */
    public function getPageContent()
    {
        $dom = pQuery::parseStr($this->getBody());
        $dom->remove('section.brz-section__header');
        $dom->remove('footer.brz-footer');

        $excludeSelectors = apply_filters('brizy_exclude_from_page_content', []);

        foreach ($excludeSelectors as $selector)
        {
            $dom->remove($selector);
        }

        return $dom->html();
    }

}
