(function ($, dms_fs) {
    var collector = {
            init: function () {
                var check,
                    config = $("#dms-submit-config");
                config.on("click", function (e) {
                    check = confirm(this.translate('Are you sure to change these settings?'));
                    if (check === false) {
                        e.preventDefault();
                    }
                });
            },
            translate: function ($string) {
                return dms_fs.translations[$string] ? dms_fs.translations[$string] : $string;
            },
            is_premium: function () {
                return dms_fs.is_premium === '0' ? false : dms_fs.is_premium === '1'
            }
        },
        controls = {
            init: function () {
                var that = this,
                    body = $('body');
                body.on('click', '.dms-delete-row', function () {
                    that.removeRow($(this));
                });

                body.on("click", '.dms-add-row', function (e) {
                    e.preventDefault();
                    that.addRow();
                });
            },
            removeRow: function (btn) {
                $(btn).closest("tr").remove();
            },
            addRow: function () {
                // Define variables
                // Get all rows,
                // Find the last index and create new index , then apply to new row ( both to row and select )
                // Get default select options, create select and apply options to it
                var map = $("#dms-map"),
                    mappings = map.find('.dms-single-mapping'),
                    multiple = collector.is_premium() ? 'multiple' : '',
                    index = mappings && mappings.length ? (mappings.last().data('index') + 1) : 0,
                    options = $($('#dms-default-select').find('select')[0]).html(),
                    tr = '<tr class="dms-empty-mapping dms-single-mapping" data-index="' + index + '">\n' +
                        '<td>\n' +
                        '<span class="pre-host">http://</span>\n' +
                        '<input type="text" name="dms_map[domains][' + index + '][host]" class="dms regular-text dms-collect-key" placeholder="www.example.com"/>\n' +
                        '<span class="post-host">/</span>\n' +
                        '<select class="dms" name="dms_map[domains][' + index + '][mappings][values][]" ' + multiple + ' data-placeholder="' + collector.translate('The choice is yours.') + '" data-index="' + index + '" >\n'
                        + options +
                        '</select>\n' +
                        '<button class="dms-delete-row" title="Delete">&times;</button>\n' +
                        '</td>' +
                        '</tr>',
                    args = {
                        placeholder: collector.translate('The choice is yours.')
                    };
                // Insert in the table
                $("#dms-add-new-tr").before($(tr));
                // Initiate new select2
                if (collector.is_premium()) {
                    args.templateSelection = select2.select2Template;
                }
                $($('#dms-map select.dms[data-index="' + index + '"]')[0]).select2(args);
            },
        },
        select2 = {
            init: function () {
                var selects = $("select.dms"),
                    args = {
                        placeholder: collector.translate('The choice is yours.')
                    };
                if (collector.is_premium()) {
                    args.templateSelection = this.select2Template;
                }
                selects.select2(args);
            },
            select2Template: function (state, container) {
                if (!state.id) {
                    return state.text;
                }
                var stateElement = $(state.element),
                    selectElement = $(state.element).parent().parent(),
                    selectedElements = selectElement.find("option:selected"),
                    isPrimary = stateElement.data('primary') ? true : (selectedElements && selectedElements.length === 1 ? stateElement.data('primary', 1) : 0),
                    index = selectElement.data('index'),
                    checked = isPrimary ? 'checked' : '',
                    $state = $(
                        '<span>' +
                        '<span class="dms-mapped-page-selected"></span>' +
                        '<span>' +
                        '<input style="margin-left: 5px;" ' +
                        'name="dms_map[domains][' + index + '][mappings][primary]" ' +
                        'value="' + state.id + '" ' +
                        'type="radio" ' + checked + '  />' +
                        '</span>' +
                        '</span>'
                    );

                $($state.find("span")[0]).text(state.text);
                $($state.find('input[type="radio"]')[0]).on('click', function (e) {
                    e.stopPropagation();
                }).on('change', function (e) {
                    // Remove data primary from all elements first
                    $(selectedElements).each(function (index) {
                        $(selectedElements[index].element).data('primary', 0);
                    });
                    // Add to exact one
                    if ($(this).is(':checked')) {
                        $(state.element).data('primary', 1);
                    } else {
                        $(state.element).data('primary', 0);
                    }
                });
                return $state;
            }
        }
    // Document ready event
    $(document).ready(function () {
        // Initializations
        collector.init();
        controls.init();
        select2.init();
        // Add empty line
        controls.addRow();
    });
})(jQuery, dms_fs);
