<?php

/*
 * Plugin Name: Domain Mapping System
 * Plugin URI: https://gauchoplugins.com/
 * Description: Allow multiple domains to point to a single WordPress installation via custom post types of pages. 
 * Version: 1.5.2
 * Author: Gaucho Plugins
 * Author URI: https://gauchoplugins.com/
 * License: GPL3
 *
 * 
 * Copyright 2020 Brand on Fire (email: support@gauchoplugins.com)
 * 
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License, version 2, as 
 * published by the Free Software Foundation.
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, see <http://www.gnu.org/licenses/>.
 */

if ( !function_exists( 'dms_fs' ) ) {
    // Create a helper function for easy SDK access.
    function dms_fs()
    {
        global  $dms_fs ;
        
        if ( !isset( $dms_fs ) ) {
            // Include Freemius SDK.
            require_once dirname( __FILE__ ) . '/vendor/freemius/start.php';
            $dms_fs = fs_dynamic_init( array(
                'id'             => '6959',
                'slug'           => 'domain-mapping-system',
                'premium_slug'   => 'domain-mapping-system-pro',
                'type'           => 'plugin',
                'public_key'     => 'pk_e348807215df985c848c86b883ee3',
                'is_premium'     => false,
                'premium_suffix' => 'Premium',
                'has_addons'     => false,
                'has_paid_plans' => true,
                'menu'           => array(
                'slug'    => 'domain-mapping-system',
                'support' => false,
                'parent'  => array(
                'slug' => 'domain-mapping-system',
            ),
            ),
                'is_live'        => true,
            ) );
        }
        
        return $dms_fs;
    }
    
    dms_fs();
    // Signal that SDK was initiated.
    function my_fs_custom_icon()
    {
        return dirname( __FILE__ ) . '/assets/img/dms-logo.jpg';
    }
    
    dms_fs()->add_filter( 'plugin_icon', 'my_fs_custom_icon' );
    do_action( 'dms_fs_loaded' );
    
    if ( dms_fs() ) {
        require_once plugin_dir_path( __FILE__ ) . 'includes/dms.class.php';
        DMS::defineProperties(
            plugin_basename( __FILE__ ),
            plugin_dir_path( __FILE__ ),
            plugin_dir_url( __FILE__ ),
            '1.5.2',
            dms_fs()
        );
        add_action(
            'init',
            array( 'DMS', 'run' ),
            1,
            1
        );
        add_action( 'init', array( 'DMS', 'load_plugin_text_domain' ), 10 );
        add_action( 'admin_init', array( 'DMS', 'adminInit' ) );
        add_action( 'admin_menu', array( 'DMS', 'adminMenu' ) );
        add_action(
            'wp',
            array( 'DMS', 'catchQueriedObject' ),
            10,
            1
        );
        add_action( 'template_redirect', array( 'DMS', 'forceRedirect' ) );
        add_filter(
            'redirect_canonical',
            array( 'DMS', 'preventHomeRedirect' ),
            1,
            2
        );
    }

}

register_deactivation_hook( __FILE__, array( 'DMS', 'deactivate' ) );
register_activation_hook( __FILE__, array( 'DMS', 'activate' ) );