<?php

if ( !empty($instance) && !empty($dms_fs) && $instance instanceof DMS && $dms_fs instanceof Freemius ) {
    ?>
    <div id="screen-meta" class="metabox-prefs" style="display: block;">
        <div id="screen-options-wrap" class="hidden" style="display: block;">
            <form id="adv-settings" action="options.php" method="post">
                <h5><?php 
    _e( 'Available Post Types', 'domain-mapping-system' );
    ?></h5>
                <em><?php 
    _e( 'Select which Builtin- and Custom Post Types should be available for DMS.', 'domain-mapping-system' );
    ?></em>
                <div class="metabox-prefs">
                    <label for="dms_use_page">
                        <input class="hide-postbox-tog" name="dms_use_page" type="checkbox" id="dms_use_page" <?php 
    $opt = get_option( 'dms_use_page' );
    if ( $opt === 'on' ) {
        echo  "checked=\"checked\"" ;
    }
    ?>>
						<?php 
    _e( 'Pages', 'domain-mapping-system' );
    ?>
                    </label>
                    <label for="dms_use_post">
                        <input class="hide-postbox-tog" name="dms_use_post" type="checkbox" id="dms_use_post" <?php 
    $opt = get_option( 'dms_use_post' );
    if ( $opt === 'on' ) {
        echo  "checked=\"checked\"" ;
    }
    ?>>
						<?php 
    _e( 'Posts', 'domain-mapping-system' );
    ?>
                    </label>
                    <label for="dms_use_categories">
                        <input class="hide-postbox-tog" name="dms_use_categories" type="checkbox" id="dms_use_categories" <?php 
    $opt = get_option( 'dms_use_categories' );
    if ( $opt === 'on' ) {
        echo  "checked=\"checked\"" ;
    }
    ?>>
						<?php 
    _e( 'Blog Categories', 'domain-mapping-system' );
    ?>
                    </label>
					<?php 
    $types = DMS::getCustomPostTypes();
    foreach ( $types as $type ) {
        echo  "<label for=\"dms_use_{$type['name']}\">" ;
        $value = get_option( "dms_use_{$type['name']}" );
        
        if ( $value === 'on' ) {
            echo  "<input class=\"hide-postbox-tog\" name=\"dms_use_{$type['name']}\" type=\"checkbox\" id=\"dms_use_{$type['name']}\" checked=\"checked\">" ;
        } else {
            echo  "<input class=\"hide-postbox-tog\" name=\"dms_use_{$type['name']}\" type=\"checkbox\" id=\"dms_use_{$type['name']}\">" ;
        }
        
        echo  $type["label"] ;
        echo  "</label>" ;
        
        if ( $type['has_archive'] ) {
            echo  "<label for=\"dms_use_{$type['name']}_archive\">" ;
            $value = get_option( "dms_use_{$type['name']}_archive" );
            
            if ( $value === 'on' ) {
                echo  "<input class=\"hide-postbox-tog\" name=\"dms_use_{$type['name']}_archive\" type=\"checkbox\" id=\"dms_use_{$type['name']}_archive\" checked=\"checked\">" ;
            } else {
                echo  "<input class=\"hide-postbox-tog\" name=\"dms_use_{$type['name']}_archive\" type=\"checkbox\" id=\"dms_use_{$type['name']}_archive\">" ;
            }
            
            echo  $type["label"] . " <strong>" . __( 'Archive', 'domain-mapping-system' ) . "</strong>" ;
            echo  "</label>" ;
        }
    
    }
    ?>
                    <br class="clear">
					<?php 
    settings_fields( 'dms_config' );
    ?>
                    <p class="submit">
                        <input type="submit" class="button-primary" value="<?php 
    _e( 'Save', 'domain-mapping-system' );
    ?>"/>
                    </p>
                </div>
            </form>
        </div>
    </div>
    <div id="screen-meta-links">
        <div id="screen-options-link-wrap" class="hide-if-no-js screen-meta-toggle">
            <a href="#screen-options-wrap" id="show-settings-link" class="show-settings screen-meta-active"><?php 
    _e( 'Configure DMS', 'domain-mapping-system' );
    ?></a>
        </div>
    </div>
    <!-- Actual Stuff -->
    <div class="wrap">
        <h2><?php 
    _e( 'Domain Mapping System Configuration', 'domain-mapping-system' );
    ?></h2>
        <div class="updated">
            <p><strong><?php 
    _e( 'Important!', 'domain-mapping-system' );
    ?></strong></p>
            <p>
				<?php 
    printf( __( 'This plugin requires configuration with your DNS host and on your server (cPanel, etc).Please see %1$sour documentation%2$s for configuration requirements.', 'domain-mapping-system' ), '<a target="_blank" href="https://docs.domainmappingsystem.com">', '</a>' );
    ?>
            </p>
        </div>
		<?php 
    $instance->showAdminNotice();
    ?>
        <form method="post" action="options.php">
			<?php 
    settings_fields( 'dms_storage' );
    ?>
            <fieldset class="dms">
                <legend>
					<?php 
    _e( 'DMS Map', 'domain-mapping-system' );
    ?>
                </legend>
                <table class="form-table" id="dms-map">
                    <tr>
                        <th scope="row" colspan="2">
                            <h3><?php 
    _e( 'Domains', 'domain-mapping-system' );
    ?></h3>
                        </th>
                    </tr>
                    <tr>
                        <td>
                            <div class="dms-mapping-desc-domain">
                                <strong><?php 
    _e( 'Enter mapped domain:', 'domain-mapping-system' );
    ?></strong>
                            </div>
                            <div class="dms-mapping-desc-page">
                                <strong><?php 
    _e( 'Select the page content to display for this domain.', 'domain-mapping-system' );
    ?><br>
									<?php 
    ?>
                                        <small>
											<?php 
    printf( __( 'To create "subsites" by mapping multiple posts, pages, products, or CPTs to a single domain, please %1$sUpgrade%2$s', 'domain-mapping-system' ), '<a href="' . $dms_fs->get_upgrade_url() . '">', ' &#8594;</a>' );
    ?>
                                        </small>
									<?php 
    ?>
                                </strong>
                            </div>
                        </td>
                    </tr>
					<?php 
    $options = DMS::getDMSOptions();
    $dms_map = get_option( 'dms_map' );
    
    if ( !empty($dms_map['domains']) ) {
        $domains = $dms_map['domains'];
        foreach ( $domains as $key => $map ) {
            $values = $map['mappings']['values'];
            $primary = ( $dms_fs->can_use_premium_code__premium_only() && !empty($map['mappings']['primary']) ? $map['mappings']['primary'] : null );
            ?>
                            <tr class="dms-single-mapping" data-index="<?php 
            echo  $key ;
            ?>">
                                <td>
                                    <span class="pre-host">http://</span>
                                    <input type="text" name="dms_map[domains][<?php 
            echo  $key ;
            ?>][host]" class="dms regular-text dms-collect-key" value="<?php 
            echo  $map['host'] ;
            ?>" placeholder="www.example.com"/>
                                    <span class="post-host">/</span>
                                    <select class="dms"
                                            name="dms_map[domains][<?php 
            echo  $key ;
            ?>][mappings][values][]"
                                            data-index="<?php 
            echo  $key ;
            ?>"
                                            data-placeholder="The choice is yours."
										<?php 
            echo  ( $dms_fs->can_use_premium_code__premium_only() ? 'multiple' : '' ) ;
            ?>>
                                        <option></option>
										<?php 
            foreach ( $options as $key_inner => $optgroup ) {
                ?>
                                            <optgroup label="<?php 
                echo  $key_inner ;
                ?>">
												<?php 
                foreach ( $optgroup as $option ) {
                    $id = $option['id'];
                    ?>
                                                    <option <?php 
                    echo  ( in_array( $id, $values ) ? 'selected' : '' ) ;
                    ?>
                                                            data-primary="<?php 
                    echo  (int) ($id == $primary) ;
                    ?>"
                                                            class="level-0"
                                                            value="<?php 
                    echo  $option['id'] ;
                    ?>"><?php 
                    echo  $option['title'] ;
                    ?></option>
													<?php 
                }
                ?>
                                            </optgroup>
											<?php 
            }
            ?>
                                    </select>
                                    <button class="dms-delete-row" title="<?php 
            _e( 'Delete', 'domain-mapping-system' );
            ?>">&times;</button>
                                </td>
                            </tr>
							<?php 
        }
    }
    
    ?>
                    <tr id="dms-add-new-tr">
                        <td>
                            <strong>
                                <a class="dms-add-row" href="#"><?php 
    _e( '+ Add Domain Map Entry', 'domain-mapping-system' );
    ?></a>
                            </strong>
                        </td>
                    </tr>
                    <tr id="dms-default-select" style="display: none">
                        <th></th>
                        <td>
                            <select <?php 
    echo  ( $dms_fs->can_use_premium_code__premium_only() ? 'multiple' : '' ) ;
    ?> data-placeholder="<?php 
    _e( 'The choice is yours.', 'domain-mapping-system' );
    ?>">
                                <option></option>
								<?php 
    foreach ( $options as $key => $optgroup ) {
        ?>
                                    <optgroup label="<?php 
        echo  $key ;
        ?>">
										<?php 
        foreach ( $optgroup as $option ) {
            ?>
                                            <option class="level-0" data-primary="0" value="<?php 
            echo  $option['id'] ;
            ?>"><?php 
            echo  $option['title'] ;
            ?></option>
											<?php 
        }
        ?>
                                    </optgroup>
									<?php 
    }
    ?>
                            </select>
                        </td>
                    </tr>
                </table>
            </fieldset>
            <p>
                <input type="checkbox" <?php 
    echo  ( !$dms_fs->can_use_premium_code__premium_only() ? 'disabled=disabled' : '' ) ;
    ?> id="dms_enable_query_strings" name="dms_enable_query_strings" <?php 
    $opt = get_option( 'dms_enable_query_strings' );
    if ( $opt === 'on' && $dms_fs->can_use_premium_code__premium_only() ) {
        echo  "checked=\"checked\"" ;
    }
    ?>/>
				<?php 
    _e( 'Support for query string parameters (e.g. - UTM, etc)', 'domain-mapping-system' );
    ?>
				<?php 
    ?>
                    <a href="<?php 
    echo  $dms_fs->get_upgrade_url() ;
    ?>"><?php 
    _e( 'Upgrade', 'domain-mapping-system' );
    ?> &#8594;</a>
				<?php 
    ?>
            </p>
            <p>
                <input type="checkbox" <?php 
    echo  ( !$dms_fs->can_use_premium_code__premium_only() ? 'disabled=disabled' : '' ) ;
    ?> id="dms_force_site_visitors" name="dms_force_site_visitors" <?php 
    $opt = get_option( 'dms_force_site_visitors' );
    if ( $opt === 'on' && $dms_fs->can_use_premium_code__premium_only() ) {
        echo  "checked=\"checked\"" ;
    }
    ?>/>
				<?php 
    _e( 'Force site visitors to see only mapped domains of a page (e.g. - disallow visitors to see the primary domain of a page)', 'domain-mapping-system' );
    ?>
				<?php 
    ?>
                    <a href="<?php 
    echo  $dms_fs->get_upgrade_url() ;
    ?>"><?php 
    _e( 'Upgrade', 'domain-mapping-system' );
    ?> &#8594;</a>
				<?php 
    ?>
            </p>
            <p>
                <input type="checkbox" <?php 
    echo  ( !$dms_fs->can_use_premium_code__premium_only() ? 'disabled=disabled' : '' ) ;
    ?> id="dms_global_mapping" name="dms_global_mapping" <?php 
    $opt = get_option( 'dms_global_mapping' );
    if ( $opt === 'on' && $dms_fs->can_use_premium_code__premium_only() ) {
        echo  "checked=\"checked\"" ;
    }
    ?>/>
				<?php 
    _e( 'Enable Global Domain Mapping (all pages will be served for your mapped domains).', 'domain-mapping-system' );
    ?>
				<?php 
    ?>
                    <a href="<?php 
    echo  $dms_fs->get_upgrade_url() ;
    ?>"><?php 
    _e( 'Upgrade', 'domain-mapping-system' );
    ?> &#8594;</a>
				<?php 
    ?>
            </p>
            <p class="submit">
                <input type="submit" class="button-primary" value="<?php 
    _e( 'Save', 'domain-mapping-system' );
    ?>" id="dms-submit-config"/>
            </p>
        </form>
    </div>
<?php 
}
