<?php

$custom_alerts = [
    __( 'WooCommerce', 'wsal-woocommerce' ) => [
        __( 'Products', 'wsal-woocommerce' )         => [
            [
                9000,
                WSAL_LOW,
                __( 'User created a new product', 'wsal-woocommerce' ),
                __( 'Created a new product called %ProductTitle%.', 'wsal-woocommerce' ),
                [
                    __( 'Product ID', 'wsal-woocommerce' ) => '%PostID%',
                    __( 'Product status', 'wsal-woocommerce' ) => '%ProductStatus%',
                ],
                [
                    __( 'View product in editor', 'wsal-woocommerce' ) => '%EditorLinkProduct%',
                ],
                'woocommerce-product',
                'created',
            ],
            [
                9001,
                WSAL_MEDIUM,
                __( 'User published a product', 'wsal-woocommerce' ),
                __( 'Published the product called %ProductTitle%.', 'wsal-woocommerce' ),
                [
                    __( 'Product ID', 'wsal-woocommerce' ) => '%PostID%',
                    __( 'Product status', 'wsal-woocommerce' ) => '%ProductStatus%',
                ],
                [
                    __( 'View product in editor', 'wsal-woocommerce' ) => '%EditorLinkProduct%',
                ],
                'woocommerce-product',
                'published',
            ],
            [
                9003,
                WSAL_LOW,
                __( 'User changed the category of a product', 'wsal-woocommerce' ),
                __( 'Changed the category(ies) of the product %ProductTitle% to %NewCategories%.', 'wsal-woocommerce' ),
                [
                    __( 'Product ID', 'wsal-woocommerce' ) => '%PostID%',
                    __( 'Product status', 'wsal-woocommerce' ) => '%ProductStatus%',
                    __( 'Previous categories', 'wsal-woocommerce' ) => '%OldCategories%',
                ],
                [
                    __( 'View product in editor', 'wsal-woocommerce' ) => '%EditorLinkProduct%',
                ],
                'woocommerce-product',
                'modified',
            ],
            [
                9004,
                WSAL_INFORMATIONAL,
                __( 'User modified the short description of a product', 'wsal-woocommerce' ),
                __( 'Changed the short description of the product %ProductTitle%.', 'wsal-woocommerce' ),
                [
                    __( 'Product ID', 'wsal-woocommerce' ) => '%PostID%',
                    __( 'Product status', 'wsal-woocommerce' ) => '%ProductStatus%',
                ],
                [
                    __( 'View product in editor', 'wsal-woocommerce' ) => '%EditorLinkProduct%',
                ],
                'woocommerce-product',
                'modified',
            ],
            [
                9005,
                WSAL_LOW,
                __( 'User modified the text of a product', 'wsal-woocommerce' ),
                __( 'Changed the text of the product %ProductTitle%.', 'wsal-woocommerce' ),
                [
                    __( 'Product ID', 'wsal-woocommerce' ) => '%PostID%',
                    __( 'Product status', 'wsal-woocommerce' ) => '%ProductStatus%',
                ],
                [
                    __( 'View product in editor', 'wsal-woocommerce' ) => '%EditorLinkProduct%',
                ],
                'woocommerce-product',
                'modified',
            ],
            [
                9006,
                WSAL_LOW,
                __( 'User changed the URL of a product', 'wsal-woocommerce' ),
                __( 'Changed the URL of the product %ProductTitle%.', 'wsal-woocommerce' ),
                [
                    __( 'Product ID', 'wsal-woocommerce' ) => '%PostID%',
                    __( 'Product status', 'wsal-woocommerce' ) => '%ProductStatus%',
                    __( 'Previous URL', 'wsal-woocommerce' ) => '%OldUrl%',
                    __( 'New URL', 'wsal-woocommerce' )    => '%NewUrl%',
                ],
                [
                    __( 'View product in editor', 'wsal-woocommerce' ) => '%EditorLinkProduct%',
                ],
                'woocommerce-product',
                'modified',
            ],
            [
                9007,
                WSAL_MEDIUM,
                __( 'User changed the Product Data of a product', 'wsal-woocommerce' ),
                __( 'Changed the type of the product %ProductTitle% to %NewType%.', 'wsal-woocommerce' ),
                [
                    __( 'Product ID', 'wsal-woocommerce' ) => '%PostID%',
                    __( 'Product status', 'wsal-woocommerce' ) => '%ProductStatus%',
                    __( 'Previous type', 'wsal-woocommerce' ) => '%OldType%',
                ],
                [
                    __( 'View product in editor', 'wsal-woocommerce' ) => '%EditorLinkProduct%',
                ],
                'woocommerce-product',
                'modified',
            ],
            [
                9008,
                WSAL_INFORMATIONAL,
                __( 'User changed the date of a product', 'wsal-woocommerce' ),
                __( 'Changed the date of the product %ProductTitle% to %NewDate%.', 'wsal-woocommerce' ),
                [
                    __( 'Product ID', 'wsal-woocommerce' ) => '%PostID%',
                    __( 'Product status', 'wsal-woocommerce' ) => '%ProductStatus%',
                    __( 'Previous date', 'wsal-woocommerce' ) => '%OldDate%',
                ],
                [
                    __( 'View product in editor', 'wsal-woocommerce' ) => '%EditorLinkProduct%',
                ],
                'woocommerce-product',
                'modified',
            ],
            [
                9009,
                WSAL_MEDIUM,
                __( 'User changed the visibility of a product', 'wsal-woocommerce' ),
                __( 'Changed the visibility of the product %ProductTitle% to %NewVisibility%.', 'wsal-woocommerce' ),
                [
                    __( 'Product ID', 'wsal-woocommerce' ) => '%PostID%',
                    __( 'Product status', 'wsal-woocommerce' ) => '%ProductStatus%',
                    __( 'Previous visibility', 'wsal-woocommerce' ) => '%OldVisibility%',
                ],
                [
                    __( 'View product in editor', 'wsal-woocommerce' ) => '%EditorLinkProduct%',
                ],
                'woocommerce-product',
                'modified',
            ],
            [
                9010,
                WSAL_MEDIUM,
                __( 'User modified the product', 'wsal-woocommerce' ),
                __( 'Modified the product %ProductTitle%.', 'wsal-woocommerce' ),
                [
                    __( 'Product ID', 'wsal-woocommerce' ) => '%PostID%',
                    __( 'Product status', 'wsal-woocommerce' ) => '%ProductStatus%',
                ],
                [
                    __( 'View product in editor', 'wsal-woocommerce' ) => '%EditorLinkProduct%',
                ],
                'woocommerce-product',
                'modified',
            ],
            [
                9011,
                E_NOTICE,
                __( 'User modified the draft product', 'wsal-woocommerce' ),
                __( 'Modified the draft product %ProductTitle%.', 'wsal-woocommerce' ),
                [],
                [
	                __( 'View product in editor', 'wsal-woocommerce' ) => '%EditorLinkProduct%'
                ],
                'woocommerce-product',
                '',
            ],
            [
                9012,
                WSAL_HIGH,
                __( 'User moved a product to trash', 'wsal-woocommerce' ),
                __( 'Moved the product %ProductTitle% to trash.', 'wsal-woocommerce' ),
                [
                    __( 'Product ID', 'wsal-woocommerce' ) => '%PostID%',
                    __( 'Product status', 'wsal-woocommerce' ) => '%ProductStatus%',
                ],
                [],
                'woocommerce-product',
                'deleted',
            ],
            [
                9013,
                WSAL_MEDIUM,
                __( 'User permanently deleted a product', 'wsal-woocommerce' ),
                __( 'Permanently deleted the product %ProductTitle%.', 'wsal-woocommerce' ),
                [
                    __( 'Product ID', 'wsal-woocommerce' ) => '%PostID%',
                ],
                [],
                'woocommerce-product',
                'deleted',
            ],
            [
                9014,
                WSAL_HIGH,
                __( 'User restored a product from the trash', 'wsal-woocommerce' ),
                __( 'Restored the product %ProductTitle% from trash.', 'wsal-woocommerce' ),
                [
                    __( 'Product ID', 'wsal-woocommerce' ) => '%PostID%',
                    __( 'Product status', 'wsal-woocommerce' ) => '%ProductStatus%',
                ],
                [
                    __( 'View product in editor', 'wsal-woocommerce' ) => '%EditorLinkProduct%',
                ],
                'woocommerce-product',
                'restored',
            ],
            [
                9015,
                WSAL_MEDIUM,
                __( 'User changed status of a product', 'wsal-woocommerce' ),
                __( 'Changed the status of the product %ProductTitle% to %NewStatus%.', 'wsal-woocommerce' ),
                [
                    __( 'Product ID', 'wsal-woocommerce' ) => '%PostID%',
                    __( 'Previous status', 'wsal-woocommerce' ) => '%OldStatus%',
                ],
                [
                    __( 'View product in editor', 'wsal-woocommerce' ) => '%EditorLinkProduct%',
                ],
                'woocommerce-product',
                'modified',
            ],
            [
                9072,
                WSAL_INFORMATIONAL,
                __( 'User opened a product in the editor', 'wsal-woocommerce' ),
                __( 'Opened the product %ProductTitle% in the editor.', 'wsal-woocommerce' ),
                [
                    __( 'Product ID', 'wsal-woocommerce' ) => '%PostID%',
                    __( 'Product status', 'wsal-woocommerce' ) => '%ProductStatus%',
                ],
                [
                    __( 'View product in editor', 'wsal-woocommerce' ) => '%EditorLinkProduct%',
                ],
                'woocommerce-product',
                'opened',
            ],
            [
                9073,
                WSAL_INFORMATIONAL,
                __( 'User viewed a product', 'wsal-woocommerce' ),
                __( 'Viewed the product %ProductTitle% page.', 'wsal-woocommerce' ),
                [
                    __( 'Product ID', 'wsal-woocommerce' ) => '%PostID%',
                    __( 'Product status', 'wsal-woocommerce' ) => '%ProductStatus%',
                ],
                [
                    __( 'View product in editor', 'wsal-woocommerce' ) => '%EditorLinkProduct%',
                ],
                'woocommerce-product',
                'viewed',
            ],
            [
                9077,
                WSAL_MEDIUM,
                __( 'User renamed a product', 'wsal-woocommerce' ),
                __( 'Renamed the product %OldTitle% to %NewTitle%.', 'wsal-woocommerce' ),
                [
                    __( 'Product ID', 'wsal-woocommerce' ) => '%PostID%',
                    __( 'Product status', 'wsal-woocommerce' ) => '%ProductStatus%',
                ],
                [
                    __( 'View product in editor', 'wsal-woocommerce' ) => '%EditorLinkProduct%',
                ],
                'woocommerce-product',
                'renamed',
            ],

            [
                9016,
                WSAL_MEDIUM,
                __( 'User changed type of a price', 'wsal-woocommerce' ),
                __( 'Changed the %PriceType% price of the product %ProductTitle% to %NewPrice%.', 'wsal-woocommerce' ),
                [
                    __( 'Product ID', 'wsal-woocommerce' ) => '%PostID%',
                    __( 'Product status', 'wsal-woocommerce' ) => '%ProductStatus%',
                    __( 'Previous price', 'wsal-woocommerce' ) => '%OldPrice%',
                ],
                [
                    __( 'View product in editor', 'wsal-woocommerce' ) => '%EditorLinkProduct%',
                ],
                'woocommerce-product',
                'modified',
            ],
            [
                9017,
                WSAL_MEDIUM,
                __( 'User changed the SKU of a product', 'wsal-woocommerce' ),
                __( 'Changed the SKU of the product %ProductTitle% to %NewSku%.', 'wsal-woocommerce' ),
                [
                    __( 'Product ID', 'wsal-woocommerce' ) => '%PostID%',
                    __( 'Product status', 'wsal-woocommerce' ) => '%ProductStatus%',
                    __( 'Previous SKU', 'wsal-woocommerce' ) => '%OldSku%',
                ],
                [
                    __( 'View product in editor', 'wsal-woocommerce' ) => '%EditorLinkProduct%',
                ],
                'woocommerce-product',
                'modified',
            ],
            [
                9018,
                WSAL_LOW,
                __( 'User changed the stock status of a product', 'wsal-woocommerce' ),
                __( 'Changed the stock status of the product %ProductTitle% to %NewStatus%.', 'wsal-woocommerce' ),
                [
                    __( 'Product ID', 'wsal-woocommerce' ) => '%PostID%',
                    __( 'Product status', 'wsal-woocommerce' ) => '%ProductStatus%',
                    __( 'Previous stock status', 'wsal-woocommerce' ) => '%OldStatus%',
                ],
                [
                    __( 'View product in editor', 'wsal-woocommerce' ) => '%EditorLinkProduct%',
                ],
                'woocommerce-product',
                'modified',
            ],
            [
                9020,
                WSAL_MEDIUM,
                __( 'User set a product type', 'wsal-woocommerce' ),
                __( 'Changed the type of the product %ProductTitle% to %NewType%.', 'wsal-woocommerce' ),
                [
                    __( 'Product ID', 'wsal-woocommerce' ) => '%PostID%',
                    __( 'Product status', 'wsal-woocommerce' ) => '%ProductStatus%',
                    __( 'Previous type', 'wsal-woocommerce' ) => '%OldType%',
                ],
                [
                    __( 'View product in editor', 'wsal-woocommerce' ) => '%EditorLinkProduct%',
                ],
                'woocommerce-product',
                'modified',
            ],
            [
                9021,
                WSAL_INFORMATIONAL,
                __( 'User changed the weight of a product', 'wsal-woocommerce' ),
                __( 'Changed the weight of the product %ProductTitle% to %NewWeight%.', 'wsal-woocommerce' ),
                [
                    __( 'Product ID', 'wsal-woocommerce' ) => '%PostID%',
                    __( 'Product status', 'wsal-woocommerce' ) => '%ProductStatus%',
                    __( 'Previous weight', 'wsal-woocommerce' ) => '%OldWeight%',
                ],
                [
                    __( 'View product in editor', 'wsal-woocommerce' ) => '%EditorLinkProduct%',
                ],
                'woocommerce-product',
                'modified',
            ],
            [
                9022,
                WSAL_INFORMATIONAL,
                __( 'User changed the dimensions of a product', 'wsal-woocommerce' ),
                __( 'Changed the %DimensionType% dimensions of the product %ProductTitle% to %NewDimension%.', 'wsal-woocommerce' ),
                [
                    __( 'Product ID', 'wsal-woocommerce' ) => '%PostID%',
                    __( 'Product status', 'wsal-woocommerce' ) => '%ProductStatus%',
                    __( 'Previous value', 'wsal-woocommerce' ) => '%OldDimension%',
                ],
                [
                    __( 'View product in editor', 'wsal-woocommerce' ) => '%EditorLinkProduct%',
                ],
                'woocommerce-product',
                'modified',
            ],
            [
                9023,
                WSAL_MEDIUM,
                __( 'User added the Downloadable File to a product', 'wsal-woocommerce' ),
                __( 'Added the downloadable file %FileName% to the product %ProductTitle%.', 'wsal-woocommerce' ),
                [
                    __( 'Product ID', 'wsal-woocommerce' ) => '%PostID%',
                    __( 'Product status', 'wsal-woocommerce' ) => '%ProductStatus%',
                    __( 'File URL', 'wsal-woocommerce' )   => '%FileUrl%',
                ],
                [
                    __( 'View product in editor', 'wsal-woocommerce' ) => '%EditorLinkProduct%',
                ],
                'woocommerce-product',
                'modified',
            ],
            [
                9024,
                WSAL_MEDIUM,
                __( 'User Removed the Downloadable File from a product', 'wsal-woocommerce' ),
                __( 'Removed the downloadable file %FileName% from the product %ProductTitle%.', 'wsal-woocommerce' ),
                [
                    __( 'Product ID', 'wsal-woocommerce' ) => '%PostID%',
                    __( 'Product status', 'wsal-woocommerce' ) => '%ProductStatus%',
                    __( 'File URL', 'wsal-woocommerce' )   => '%FileUrl%',
                ],
                [
                    __( 'View product in editor', 'wsal-woocommerce' ) => '%EditorLinkProduct%',
                ],
                'woocommerce-product',
                'modified',
            ],
            [
                9025,
                WSAL_INFORMATIONAL,
                __( 'User changed the name of a Downloadable File in a product', 'wsal-woocommerce' ),
                __( 'Changed the name of the downloadable file %OldName% to %NewName% in the product %ProductTitle%.', 'wsal-woocommerce' ),
                [
                    __( 'Product ID', 'wsal-woocommerce' ) => '%PostID%',
                    __( 'Product status', 'wsal-woocommerce' ) => '%ProductStatus%',
                    __( 'Previous file name', 'wsal-woocommerce' ) => '%OldName%',
                ],
                [
                    __( 'View product in editor', 'wsal-woocommerce' ) => '%EditorLinkProduct%',
                ],
                'woocommerce-product',
                'modified',
            ],
            [
                9026,
                WSAL_MEDIUM,
                __( 'User changed the URL of the Downloadable File in a product', 'wsal-woocommerce' ),
                __( 'Changed the URL of the downloadable file to the product %ProductTitle%', 'wsal-woocommerce' ),
                [
                    __( 'Product ID', 'wsal-woocommerce' ) => '%PostID%',
                    __( 'Product status', 'wsal-woocommerce' ) => '%ProductStatus%',
                    __( 'File name', 'wsal-woocommerce' )  => '%FileName%',
                    __( 'Previous URL', 'wsal-woocommerce' ) => '%OldUrl%',
                    __( 'New URL', 'wsal-woocommerce' )    => '%NewUrl%',
                ],
                [
                    __( 'View product in editor', 'wsal-woocommerce' ) => '%EditorLinkProduct%',
                ],
                'woocommerce-product',
                'modified',
            ],
            [
                9042,
                WSAL_INFORMATIONAL,
                __( 'User changed the catalog visibility of a product', 'wsal-woocommerce' ),
                __( 'Changed the product visibility of the product %ProductTitle% to %NewVisibility%.', 'wsal-woocommerce' ),
                [
                    __( 'Product ID', 'wsal-woocommerce' ) => '%PostID%',
                    __( 'Product status', 'wsal-woocommerce' ) => '%ProductStatus%',
                    __( 'Previous visibility setting', 'wsal-woocommerce' ) => '%OldVisibility%',
                ],
                [
                    __( 'View product in editor', 'wsal-woocommerce' ) => '%EditorLinkProduct%',
                ],
                'woocommerce-product',
                'modified',
            ],
            [
                9043,
                WSAL_INFORMATIONAL,
                __( 'User changed the setting Featured Product of a product', 'wsal-woocommerce' ),
                __( 'Changed the status of the setting <strong>Featured Product</strong> for the product %ProductTitle%.', 'wsal-woocommerce' ),
                [
                    __( 'Product ID', 'wsal-woocommerce' ) => '%PostID%',
                    __( 'Product status', 'wsal-woocommerce' ) => '%ProductStatus%',
                ],
                [
                    __( 'View product in editor', 'wsal-woocommerce' ) => '%EditorLinkProduct%',
                ],
                'woocommerce-product',
                'enabled',
            ],
            [
                9044,
                WSAL_INFORMATIONAL,
                __( 'User changed the Allow Backorders setting of a product', 'wsal-woocommerce' ),
                __( 'Changed the Allow Backorders setting for the product %ProductTitle% to %NewStatus%.', 'wsal-woocommerce' ),
                [
                    __( 'Product ID', 'wsal-woocommerce' ) => '%PostID%',
                    __( 'Product status', 'wsal-woocommerce' ) => '%ProductStatus%',
                    __( 'Previous status', 'wsal-woocommerce' ) => '%OldStatus%',
                ],
                [
                    __( 'View product in editor', 'wsal-woocommerce' ) => '%EditorLinkProduct%',
                ],
                'woocommerce-product',
                'modified',
            ],
            [
                9045,
                WSAL_MEDIUM,
                __( 'User added/removed products to upsell of a product', 'wsal-woocommerce' ),
                __( 'Products to the Upsell setting in product %ProductTitle%.', 'wsal-woocommerce' ),
                [
                    __( 'Product ID', 'wsal-woocommerce' ) => '%PostID%',
                    __( 'Product status', 'wsal-woocommerce' ) => '%ProductStatus%',
                    __( 'New product in Upsells', 'wsal-woocommerce' ) => '%UpsellTitle%',
                ],
                [
                    __( 'View product in editor', 'wsal-woocommerce' ) => '%EditorLinkProduct%',
                ],
                'woocommerce-product',
                'added',
            ],
            [
                9046,
                WSAL_MEDIUM,
                __( 'User added/removed products to cross-sells of a product', 'wsal-woocommerce' ),
                __( 'Products to the Cross-sell setting in product %ProductTitle%.', 'wsal-woocommerce' ),
                [
                    __( 'Product ID', 'wsal-woocommerce' ) => '%PostID%',
                    __( 'Product status', 'wsal-woocommerce' ) => '%ProductStatus%',
                    __( 'New product in Cross-sells', 'wsal-woocommerce' ) => '%CrossSellTitle%',
                ],
                [
                    __( 'View product in editor', 'wsal-woocommerce' ) => '%EditorLinkProduct%',
                ],
                'woocommerce-product',
                'added',
            ],

            [
                9095,
                WSAL_LOW,
                __( 'Added or deleted a product image', 'wsal-woocommerce' ),
                __( 'The product image of the product %ProductTitle%.', 'wsal-woocommerce' ),
                [
                    __( 'Product ID', 'wsal-woocommerce' ) => '%PostID%',
                    __( 'Product status', 'wsal-woocommerce' ) => '%ProductStatus%',
                    __( 'Image name', 'wsal-woocommerce' ) => '%name%',
                    __( 'Image path', 'wsal-woocommerce' ) => '%path%',
                ],
                [
                    __( 'View product in editor', 'wsal-woocommerce' ) => '%EditorLinkProduct%',
                ],
                'woocommerce-product',
                'added',
            ],
            [
                9096,
                WSAL_LOW,
                __( 'Modified a product image', 'wsal-woocommerce' ),
                __( 'Changed the product image of the product %ProductTitle%.', 'wsal-woocommerce' ),
                [
                    __( 'Product ID', 'wsal-woocommerce' ) => '%PostID%',
                    __( 'Product status', 'wsal-woocommerce' ) => '%ProductStatus%',
                    __( 'Previous image name', 'wsal-woocommerce' ) => '%old_name%',
                    __( 'Previous image path', 'wsal-woocommerce' ) => '%old_path%',
                    __( 'New image name', 'wsal-woocommerce' ) => '%name%',
                    __( 'New image path', 'wsal-woocommerce' ) => '%path%',
                ],
                [
                    __( 'View product in editor', 'wsal-woocommerce' ) => '%EditorLinkProduct%',
                ],
                'woocommerce-product',
                'modified',
            ],
            [
                9097,
                WSAL_LOW,
                __( 'Modified the download limit of the product', 'wsal-woocommerce' ),
                __( 'Changed the download limit of the product %product_name% to %new_value%.', 'wsal-woocommerce' ),
                [
                    __( 'Product ID', 'wsal-woocommerce' ) => '%ID%',
                    __( 'Product status', 'wsal-woocommerce' ) => '%ProductStatus%',
                    __( 'Previous value', 'wsal-woocommerce' ) => '%previous_value%',
                ],
                [
                    __( 'View product in editor', 'wsal-woocommerce' ) => '%EditorLinkProduct%',
                ],
                'woocommerce-product',
                'modified',
            ],
            [
                9098,
                WSAL_LOW,
                __( 'Modified the download expiry setting of the product', 'wsal-woocommerce' ),
                __( 'Changed the download expire setting of the product %product_name% to %new_value%.', 'wsal-woocommerce' ),
                [
                    __( 'Product ID', 'wsal-woocommerce' ) => '%ID%',
                    __( 'Product status', 'wsal-woocommerce' ) => '%ProductStatus%',
                    __( 'Previous value', 'wsal-woocommerce' ) => '%previous_value%',
                ],
                [
                    __( 'View product in editor', 'wsal-woocommerce' ) => '%EditorLinkProduct%',
                ],
                'woocommerce-product',
                'modified',
            ],
            [
                9099,
                WSAL_LOW,
                __( 'A product was downloaded', 'wsal-woocommerce' ),
                __( 'Downloaded the product %product_name%.', 'wsal-woocommerce' ),
                [
                    __( 'Product ID', 'wsal-woocommerce' ) => '%ID%',
                    __( 'User email', 'wsal-woocommerce' ) => '%email_address%',
                ],
                [],
                'woocommerce-product',
                'modified',
            ],

            [
                9105,
                WSAL_LOW,
                __( 'System changed the stock quantity of a product', 'wsal-woocommerce' ),
                __( 'The stock quantity of the product %ProductTitle% was changed to %NewValue% due to a purchase.', 'wsal-woocommerce' ),
                [
                    __( 'Product ID', 'wsal-woocommerce' ) => '%PostID%',
                    __( 'User name', 'wsal-woocommerce' )  => '%Username%',
	                __( 'Order name', 'wsal-woocommerce' ) => '%StockOrderID%',
                    __( 'Product status', 'wsal-woocommerce' ) => '%ProductStatus%',
                    __( 'Previous quantity', 'wsal-woocommerce' ) => '%OldValue%',
                ],
                [
                    __( 'View product in editor', 'wsal-woocommerce' ) => '%EditorLinkProduct%',
                ],
                'woocommerce-product',
                'modified',
            ],
            [
                9106,
                WSAL_LOW,
                __( 'Third-party plugin changed the stock quantity of a product', 'wsal-woocommerce' ),
                __( 'The stock quantity of the product %ProductTitle% was changed to %NewValue% via third party system.', 'wsal-woocommerce' ),
                [
                    __( 'Product ID', 'wsal-woocommerce' ) => '%PostID%',
                    __( 'Product status', 'wsal-woocommerce' ) => '%ProductStatus%',
                    __( 'Previous quantity', 'wsal-woocommerce' ) => '%OldValue%',
                ],
                [
                    __( 'View product in editor', 'wsal-woocommerce' ) => '%EditorLinkProduct%',
                ],
                'woocommerce-product',
                'modified',
            ],
            [
                9113,
                WSAL_MEDIUM,
                __( 'The Tax status of a product has been modified', 'wsal-woocommerce' ),
                __( 'Changed the Tax status of the product %ProductTitle% to %new_tax_status%.', 'wsal-woocommerce' ),
                [
                    __( 'Product ID', 'wsal-woocommerce' ) => '%PostID%',
                    __( 'Product status', 'wsal-woocommerce' ) => '%ProductStatus%',
                    __( 'Previous tax status', 'wsal-woocommerce' ) => '%old_tax_status%',
                ],
                [
                    __( 'View product in editor', 'wsal-woocommerce' ) => '%EditorLinkProduct%',
                ],
                'woocommerce-product',
                'modified',
            ],
            [
                9114,
                WSAL_MEDIUM,
                __( 'The Tax class of a product has been modified', 'wsal-woocommerce' ),
                __( 'Changed the Tax class of the product %ProductTitle% to %new_tax_class%.', 'wsal-woocommerce' ),
                [
                    __( 'Product ID', 'wsal-woocommerce' ) => '%PostID%',
                    __( 'Product status', 'wsal-woocommerce' ) => '%ProductStatus%',
                    __( 'Previous tax class', 'wsal-woocommerce' ) => '%old_tax_class%',
                ],
                [
                    __( 'View product in editor', 'wsal-woocommerce' ) => '%EditorLinkProduct%',
                ],
                'woocommerce-product',
                'modified',
            ],

            [
                9019,
                WSAL_LOW,
                __( 'User changed the stock quantity', 'wsal-woocommerce' ),
                __( 'Changed the stock quantity of the product %ProductTitle% to %NewValue%.', 'wsal-woocommerce' ),
                [
                    __( 'Product ID', 'wsal-woocommerce' ) => '%PostID%',
                    __( 'Product status', 'wsal-woocommerce' ) => '%ProductStatus%',
                    __( 'Previous quantity', 'wsal-woocommerce' ) => '%OldValue%',
                ],
                [
                    __( 'View product in editor', 'wsal-woocommerce' ) => '%EditorLinkProduct%',
                ],
                'woocommerce-product',
                'modified',
            ],

            [
                9047,
                WSAL_LOW,
                __( 'Added a new attribute of a product', 'wsal-woocommerce' ),
                __( 'Added a new attribute caled %AttributeName% to the product %ProductTitle%.', 'wsal-woocommerce' ),
                [
                    __( 'Product ID', 'wsal-woocommerce' ) => '%ProductID%',
                    __( 'Product status', 'wsal-woocommerce' ) => '%ProductStatus%',
                    __( 'Attribute value', 'wsal-woocommerce' ) => '%AttributeValue%',
                ],
                [
                    __( 'View product in editor', 'wsal-woocommerce' ) => '%EditorLinkProduct%',
                ],
                'woocommerce-product',
                'added',
            ],
            [
                9048,
                WSAL_LOW,
                __( 'Modified the value of an attribute of a product', 'wsal-woocommerce' ),
                __( 'Modified the value of the attribute %AttributeName$ in the product %ProductTitle%.', 'wsal-woocommerce' ),
                [
                    __( 'Product ID', 'wsal-woocommerce' ) => '%ProductID%',
                    __( 'Product status', 'wsal-woocommerce' ) => '%ProductStatus%',
                    __( 'Previous attribute value', 'wsal-woocommerce' ) => '%OldValue%',
                    __( 'New attribute value', 'wsal-woocommerce' ) => '%NewValue%',
                ],
                [
                    __( 'View product in editor', 'wsal-woocommerce' ) => '%EditorLinkProduct%',
                ],
                'woocommerce-product',
                'modified',
            ],
            [
                9049,
                WSAL_LOW,
                __( 'Changed the name of an attribute of a product', 'wsal-woocommerce' ),
                __( 'Renamed the attribute %OldValue% to %NewValue% in the product %ProductTitle%.', 'wsal-woocommerce' ),
                [
                    __( 'Product ID', 'wsal-woocommerce' ) => '%ProductID%',
                    __( 'Product status', 'wsal-woocommerce' ) => '%ProductStatus%',
                ],
                [
                    __( 'View product in editor', 'wsal-woocommerce' ) => '%EditorLinkProduct%',
                ],
                'woocommerce-product',
                'renamed',
            ],
            [
                9050,
                WSAL_LOW,
                __( 'Deleted an attribute of a product', 'wsal-woocommerce' ),
                __( 'Deleted the attribute %AttributeName% from the product %ProductTitle%.', 'wsal-woocommerce' ),
                [
                    __( 'Product ID', 'wsal-woocommerce' ) => '%ProductID%',
                    __( 'Product status', 'wsal-woocommerce' ) => '%ProductStatus%',
                    __( 'Attribute value', 'wsal-woocommerce' ) => '%AttributeValue%',
                ],
                [
                    __( 'View product in editor', 'wsal-woocommerce' ) => '%EditorLinkProduct%',
                ],
                'woocommerce-product',
                'deleted',
            ],
            [
                9051,
                WSAL_LOW,
                __( 'Set the attribute visibility of a product', 'wsal-woocommerce' ),
                __( 'Changed the visibility of the attribute %AttributeName% to %AttributeVisiblilty% in the the product %ProductTitle%.', 'wsal-woocommerce' ),
                [
                    __( 'Product ID', 'wsal-woocommerce' ) => '%ProductID%',
                    __( 'Product status', 'wsal-woocommerce' ) => '%ProductStatus%',
                    __( 'Previous visibility', 'wsal-woocommerce' ) => '%OldAttributeVisiblilty%',
                ],
                [
                    __( 'View product in editor', 'wsal-woocommerce' ) => '%EditorLinkProduct%',
                ],
                'woocommerce-product',
                'modified',
            ],
        ],

        __( 'Store', 'wsal-woocommerce' )            => [
            [
                9027,
                WSAL_HIGH,
                __( 'User changed the Weight Unit', 'wsal-woocommerce' ),
                __( 'Changed the <strong>weight unit</strong> of the store to %NewUnit%.', 'wsal-woocommerce' ),
                [
                    __( 'Previous weight unit', 'wsal-woocommerce' ) => '%OldUnit%',
                ],
                [],
                'woocommerce-store',
                'modified',
            ],
            [
                9028,
                WSAL_HIGH,
                __( 'User changed the Dimensions Unit', 'wsal-woocommerce' ),
                __( 'Changed the <strong>dimensions unit</strong> of the store to %NewUnit%.', 'wsal-woocommerce' ),
                [
                    __( 'Previous dimensions unit', 'wsal-woocommerce' ) => '%OldUnit%',
                ],
                [],
                'woocommerce-store',
                'modified',
            ],
            [
                9029,
                WSAL_HIGH,
                __( 'User changed the Base Location', 'wsal-woocommerce' ),
                __( 'Changed the <strong>base location</strong> of the store to %NewLocation%.', 'wsal-woocommerce' ),
                [
                    __( 'Previous address', 'wsal-woocommerce' ) => '%OldLocation%',
                ],
                [],
                'woocommerce-store',
                'modified',
            ],
            [
                9030,
                WSAL_HIGH,
                __( 'User enabled/disabled taxes', 'wsal-woocommerce' ),
                __( 'Changed the status of the <strong>Taxes</strong> store setting.', 'wsal-woocommerce' ),
                [],
                [],
                'woocommerce-store',
                'enabled',
            ],
            [
                9031,
                WSAL_HIGH,
                __( 'User changed the currency', 'wsal-woocommerce' ),
                __( 'Changed the <strong>currency</strong> of the store to %NewCurrency%.', 'wsal-woocommerce' ),
                [
                    __( 'Previous currency', 'wsal-woocommerce' ) => '%OldCurrency%',
                ],
                [],
                'woocommerce-store',
                'modified',
            ],
            [
                9032,
                WSAL_HIGH,
                __( 'User enabled/disabled the use of coupons during checkout', 'wsal-woocommerce' ),
                __( 'Changed the status of the store setting <strong>use of coupons during checkout</strong>.', 'wsal-woocommerce' ),
                [],
                [],
                'woocommerce-store',
                'enabled',
            ],
            [
                9033,
                WSAL_MEDIUM,
                __( 'User enabled/disabled guest checkout', 'wsal-woocommerce' ),
                __( 'Changed the status of the store setting <strong>Guest checkout</strong>.', 'wsal-woocommerce' ),
                [],
                [],
                'woocommerce-store',
                'enabled',
            ],
            [
                9034,
                WSAL_HIGH,
                __( 'User enabled/disabled Cash on delivery', 'wsal-woocommerce' ),
                __( 'Changed the status of the store setting <strong>cash on delivery</strong>', 'wsal-woocommerce' ),
                [],
                [],
                'woocommerce-store',
                'enabled',
            ],
            [
                9085,
                WSAL_HIGH,
                __( 'User modified selling location(s)', 'wsal-woocommerce' ),
                __( 'Changed the store setting <strong>Selling location(s)</strong> to %new%.', 'wsal-woocommerce' ),
                [
                    __( 'Previous setting', 'wsal-woocommerce' ) => '%old%',
                ],
                [],
                'woocommerce-store',
                'modified',
            ],
            [
                9086,
                WSAL_HIGH,
                __( 'User modified excluded selling location(s)', 'wsal-woocommerce' ),
                __( 'Changed the <strong>list of excluded countries to sell to</strong> setting in the store.', 'wsal-woocommerce' ),
                [
                    __( 'Previous list of countries', 'wsal-woocommerce' ) => '%old%',
                    __( 'New list of countries', 'wsal-woocommerce' ) => '%new%',
                ],
                [],
                'woocommerce-store',
                'modified',
            ],
            [
                9087,
                WSAL_HIGH,
                __( 'User modified exclusive selling location(s)', 'wsal-woocommerce' ),
                __( 'Changed the <strong>list of countries to sell to</strong> setting in the store.', 'wsal-woocommerce' ),
                [
                    __( 'Previous list of countries', 'wsal-woocommerce' ) => '%old%',
                    __( 'New list of countries', 'wsal-woocommerce' ) => '%new%',
                ],
                [],
                'woocommerce-store',
                'modified',
            ],
            [
                9088,
                WSAL_HIGH,
                __( 'User modified shipping location(s)', 'wsal-woocommerce' ),
                __( 'Changed the <strong>Shipping location(s)</strong> setting in the store.', 'wsal-woocommerce' ),
                [
                    __( 'Previous setting', 'wsal-woocommerce' ) => '%old%',
                    __( 'New Setting', 'wsal-woocommerce' ) => '%new%',
                ],
                [],
                'woocommerce-store',
                'modified',
            ],
            [
                9089,
                WSAL_HIGH,
                __( 'User modified exclusive shipping location(s)', 'wsal-woocommerce' ),
                __( 'Changed the <strong>List of specific countries to</strong> ship to setting in the store.', 'wsal-woocommerce' ),
                [
                    __( 'Previous list of countries', 'wsal-woocommerce' ) => '%old%',
                    __( 'New list of countries', 'wsal-woocommerce' ) => '%new%',
                ],
                [],
                'woocommerce-store',
                'modified',
            ],
            [
                9090,
                WSAL_HIGH,
                __( 'User modified default customer location', 'wsal-woocommerce' ),
                __( 'Changed the <strong>Default customer location</strong> setting to %new%.', 'wsal-woocommerce' ),
                [
                    __( 'Previous location', 'wsal-woocommerce' ) => '%old%',
                ],
                [],
                'woocommerce-store',
                'modified',
            ],
            [
                9091,
                WSAL_HIGH,
                __( 'User modified the cart page', 'wsal-woocommerce' ),
                __( 'Changed the store\'s <strong>Cart page</strong> to %new%.', 'wsal-woocommerce' ),
                [
                    __( 'Previous page', 'wsal-woocommerce' ) => '%old%',
                ],
                [],
                'woocommerce-store',
                'modified',
            ],
            [
                9092,
                WSAL_HIGH,
                __( 'User modified the checkout page', 'wsal-woocommerce' ),
                __( 'Changed the store\'s <strong>Checkout page</strong> to %new%.', 'wsal-woocommerce' ),
                [
                    __( 'Previous page', 'wsal-woocommerce' ) => '%old%',
                ],
                [],
                'woocommerce-store',
                'modified',
            ],
            [
                9093,
                WSAL_HIGH,
                __( 'User modified the my account page', 'wsal-woocommerce' ),
                __( 'Changed the store\'s <strong>My account page</strong> to %new%.', 'wsal-woocommerce' ),
                [
                    __( 'Previous page', 'wsal-woocommerce' ) => '%old%',
                ],
                [],
                'woocommerce-store',
                'modified',
            ],
            [
                9094,
                WSAL_HIGH,
                __( 'User modified the terms and conditions page', 'wsal-woocommerce' ),
                __( 'Changed the store\'s <strong>Terms and conditions page</strong> to %new%.', 'wsal-woocommerce' ),
                [
                    __( 'Previous page', 'wsal-woocommerce' ) => '%old%',
                ],
                [],
                'woocommerce-store',
                'modified',
            ],
            [
                9100,
                WSAL_MEDIUM,
                __( 'Changed the status of the Enable product reviews setting in the store', 'wsal-woocommerce' ),
                __( 'Changed the status of the <strong>Enable product reviews</strong> setting in the store.', 'wsal-woocommerce' ),
                [],
                [],
                'woocommerce-store',
                'modified',
            ],
            [
                9107,
                WSAL_LOW,
                __( 'Changed the status of the Show "verified owner" label on customer reviews setting in the store', 'wsal-woocommerce' ),
                __( 'Changed the status of the <strong>Show "verified owner" label on customer reviews</strong> setting in the store.', 'wsal-woocommerce' ),
                [],
                [],
                'woocommerce-store',
                'modified',
            ],
            [
                9108,
                WSAL_LOW,
                __( 'Changed the status of the Reviews can only be left by "verified owners" setting in the store', 'wsal-woocommerce' ),
                __( 'Changed the status of the <strong>Reviews can only be left by "verified owners"</strong> setting in the store.', 'wsal-woocommerce' ),
                [],
                [],
                'woocommerce-store',
                'modified',
            ],
            [
                9109,
                WSAL_MEDIUM,
                __( 'Changed the status of the Star rating on reviews setting in the store', 'wsal-woocommerce' ),
                __( 'Changed the status of the <strong>Star rating on reviews</strong> setting in the store.', 'wsal-woocommerce' ),
                [],
                [],
                'woocommerce-store',
                'modified',
            ],
            [
                9110,
                WSAL_MEDIUM,
                __( 'Changed the status of the Star ratings should be required setting in the store', 'wsal-woocommerce' ),
                __( 'Changed the status of the <strong>Star ratings should be required</strong> setting in the store.', 'wsal-woocommerce' ),
                [],
                [],
                'woocommerce-store',
                'modified',
            ],
            [
                9111,
                WSAL_MEDIUM,
                __( 'A Checkout endpoint has been modified', 'wsal-woocommerce' ),
                __( 'Changed the <strong>Checkout endpoint</strong> %endpoint_name% to %new_value%.', 'wsal-woocommerce' ),
                [
                    __( 'Previous endpoint value', 'wsal-woocommerce' ) => '%old%',
                ],
                [],
                'woocommerce-store',
                'modified',
            ],
            [
                9112,
                WSAL_MEDIUM,
                __( 'An Account endpoint has been modified', 'wsal-woocommerce' ),
                __( 'Changed the <strong>Account endpoint</strong> %endpoint_name% to %new_value%.', 'wsal-woocommerce' ),
                [
                    __( 'Previous endpoint value', 'wsal-woocommerce' ) => '%old%',
                ],
                [],
                'woocommerce-store',
                'modified',
            ],
        ],

        __( 'Payment Gateways', 'wsal-woocommerce' ) => [
            [
                9074,
                WSAL_HIGH,
                __( 'User enabled/disabled a payment gateway', 'wsal-woocommerce' ),
                __( 'Changed the status of the payment gateway %GatewayName%.', 'wsal-woocommerce' ),
                [],
                [],
                'woocommerce-store',
                'enabled',
            ],
            [
                9075,
                E_CRITICAL,
                __( 'User disabled a payment gateway', 'wsal-woocommerce' ),
                __( 'User disabled a payment gateway', 'wsal-woocommerce' ),
                [
                    __( 'The payment gateway', 'wsal-woocommerce' ) => '%GatewayName%',
                ],
                [],
                'woocommerce-store',
                '',
            ],
            [
                9076,
                WSAL_HIGH,
                __( 'User modified a payment gateway', 'wsal-woocommerce' ),
                __( 'Changed the settings of the %GatewayName% payment gateway.', 'wsal-woocommerce' ),
                [],
                [],
                'woocommerce-store',
                'modified',
            ],
        ],

        __( 'Tax Settings', 'wsal-woocommerce' )     => [
            [
                9078,
                WSAL_LOW,
                __( 'User modified prices with tax option', 'wsal-woocommerce' ),
                __( 'Changed the store setting <strong>Prices entered with tax</strong> to %TaxStatus% taxes.', 'wsal-woocommerce' ),
                [],
                [],
                'woocommerce-store',
                'modified',
            ],
            [
                9079,
                WSAL_LOW,
                __( 'User modified tax calculation base', 'wsal-woocommerce' ),
                __( 'Changed the store setting <strong>Calculate tax based on</strong> to %Setting%', 'wsal-woocommerce' ),
                [],
                [],
                'woocommerce-store',
                'modified',
            ],
            [
                9080,
                WSAL_MEDIUM,
                __( 'User modified shipping tax class', 'wsal-woocommerce' ),
                __( 'Changed the store setting <strong>Shipping tax class</strong> to %Setting%', 'wsal-woocommerce' ),
                [],
                [],
                'woocommerce-store',
                'modified',
            ],
            [
                9081,
                WSAL_MEDIUM,
                __( 'User enabled/disabled rounding of tax', 'wsal-woocommerce' ),
                __( 'Changed the status of the store tax setting <strong>Rounding</strong> of tax at subtotal level.', 'wsal-woocommerce' ),
                [],
                [],
                'woocommerce-store',
                'enabled',
            ],
            [
                9082,
                WSAL_MEDIUM,
                __( 'User modified a shipping zone', 'wsal-woocommerce' ),
                __( 'The shipping zone %ShippingZoneName% on the WooCommerce store', 'wsal-woocommerce' ),
                [],
                [],
                'woocommerce-store',
                'created',
            ],
        ],

        __( 'WC Categories', 'wsal-woocommerce' )    => [
            [
                9002,
                WSAL_INFORMATIONAL,
                __( 'User created a new product category', 'wsal-woocommerce' ),
                __( 'Created new product category called %CategoryName%.', 'wsal-woocommerce' ),
                [
                    __( 'Category slug', 'wsal-woocommerce' ) => '%Slug%',
                ],
                [
                    __( 'View category', 'wsal-woocommerce' ) => '%ProductCatLink%',
                ],
                'woocommerce-category',
                'created',
            ],
            [
                9052,
                WSAL_MEDIUM,
                __( 'User deleted a product category', 'wsal-woocommerce' ),
				__( 'Deleted the product category called %CategoryName%.', 'wsal-woocommerce' ),
                [
                    __( 'Category slug', 'wsal-woocommerce' ) => '%CategorySlug%',
                ],
                [],
                'woocommerce-category',
                'deleted',
            ],
            [
                9053,
                WSAL_INFORMATIONAL,
                __( 'User changed the slug of a product category', 'wsal-woocommerce' ),
                __( 'Changed the slug of the product category called %CategoryName%.', 'wsal-woocommerce' ),
                [
                    __( 'Previous category slug', 'wsal-woocommerce' ) => '%OldSlug%',
                    __( 'New category slug', 'wsal-woocommerce' ) => '%NewSlug%',
                ],
                [
                    __( 'View category', 'wsal-woocommerce' ) => '%ProductCatLink%',
                ],
                'woocommerce-category',
                'modified',
            ],
            [
                9054,
                WSAL_MEDIUM,
                __( 'User changed the parent category of a product category', 'wsal-woocommerce' ),
                __( 'Changed the parent of the product category %CategoryName% to %NewParentCat%.', 'wsal-woocommerce' ),
                [
                    __( 'Category slug', 'wsal-woocommerce' ) => '%CategorySlug%',
                    __( 'Previous parent', 'wsal-woocommerce' ) => '%OldParentCat%',
                ],
                [
                    __( 'View category', 'wsal-woocommerce' ) => '%ProductCatLink%',
                ],
                'woocommerce-category',
                'modified',
            ],
            [
                9055,
                WSAL_INFORMATIONAL,
                __( 'User changed the display type of a product category', 'wsal-woocommerce' ),
                __( 'Changed the display type of the product category %name% to %NewDisplayType%.', 'wsal-woocommerce' ),
                [
                    __( 'Category slug', 'wsal-woocommerce' ) => '%CategorySlug%',
                    __( 'Previous display type', 'wsal-woocommerce' ) => '%OldDisplayType%',
                ],
                [
                    __( 'View category', 'wsal-woocommerce' ) => '%ProductCatLink%',
                ],
                'woocommerce-category',
                'modified',
            ],
            [
                9056,
                WSAL_LOW,
                __( 'User changed the name of a product category', 'wsal-woocommerce' ),
                __( 'Renamed the product category %OldName% to %NewName%.', 'wsal-woocommerce' ),
                [
                    __( 'Previous category name', 'wsal-woocommerce' ) => '%OldName%',
                    __( 'Category slug', 'wsal-woocommerce' ) => '%CategorySlug%',
                ],
                [
                    __( 'View category', 'wsal-woocommerce' ) => '%ProductCatLink%',
                ],
                'woocommerce-category',
                'renamed',
            ],
        ],

        __( 'WC Tags', 'wsal-woocommerce' )          => [
            [
                9101,
                WSAL_INFORMATIONAL,
                __( 'User created a new product tag', 'wsal-woocommerce' ),
                __( 'Created the tag %CategoryName%.', 'wsal-woocommerce' ),
                [
                    __( 'Slug', 'wsal-woocommerce' )     => '%Slug%',
                ],
                [
                    __( 'View product tag', 'wsal-woocommerce' ) => '%ProductTagLink%',
                ],
                'woocommerce-tag',
                'created',
            ],
            [
                9102,
                WSAL_INFORMATIONAL,
                __( 'User deleted a product tag', 'wsal-woocommerce' ),
                __( 'Deleted the tag %Name%.', 'wsal-woocommerce' ),
                [
                    __( 'Slug', 'wsal-woocommerce' )     => '%Slug%',
                ],
                [],
                'woocommerce-tag',
                'deleted',
            ],
            [
                9103,
                WSAL_INFORMATIONAL,
                __( 'User renamed product tag', 'wsal-woocommerce' ),
                __( 'Renamed the tag %OldName% to %NewName%.', 'wsal-woocommerce' ),
                [
                    __( 'Slug', 'wsal-woocommerce' )     => '%Slug%',
                ],
                [
                    __( 'View product tag', 'wsal-woocommerce' ) => '%ProductTagLink%',
                ],
                'woocommerce-tag',
                'renamed',
            ],
            [
                9104,
                WSAL_INFORMATIONAL,
                __( 'User changed product tag slug', 'wsal-woocommerce' ),
                __( 'Changed the slug of the tag %TagName% to %NewSlug%.', 'wsal-woocommerce' ),
                [
                    __( 'Previous slug', 'wsal-woocommerce' ) => '%OldSlug%',
                ],
                [
                    __( 'View product tag', 'wsal-woocommerce' ) => '%ProductTagLink%',
                ],
                'woocommerce-tag',
                'modified',
            ],
        ],

        __( 'Attributes', 'wsal-woocommerce' )       => [
            [
                9057,
                WSAL_MEDIUM,
                __( 'User created a new attribute', 'wsal-woocommerce' ),
                __( 'Created a new attribute in WooCommerce called %AttributeName%.', 'wsal-woocommerce' ),
                [
                    __( 'Attribute slug', 'wsal-woocommerce' ) => '%AttributeSlug%',
                ],
                [],
                'woocommerce-store',
                'created',
            ],
            [
                9058,
                WSAL_LOW,
                __( 'User deleted an attribute', 'wsal-woocommerce' ),
                __( 'Deleted the WooCommerce attribute %AttributeName%.', 'wsal-woocommerce' ),
                [
                    __( 'Attribute slug', 'wsal-woocommerce' ) => '%AttributeSlug%',
                ],
                [],
                'woocommerce-store',
                'deleted',
            ],
            [
                9059,
                WSAL_LOW,
                __( 'User changed the slug of an attribute', 'wsal-woocommerce' ),
                __( 'Changed the slug of the WooCommerce attribute %AttributeName% to %NewSlug%.', 'wsal-woocommerce' ),
                [
                    __( 'Previous slug', 'wsal-woocommerce' ) => '%OldSlug%',
                ],
                [],
                'woocommerce-store',
                'modified',
            ],
            [
                9060,
                WSAL_LOW,
                __( 'User changed the name of an attribute', 'wsal-woocommerce' ),
                __( 'Renamed the WooCommerce attribute %AttributeName% to %NewName%.', 'wsal-woocommerce' ),
                [
                    __( 'Attribute slug', 'wsal-woocommerce' ) => '%AttributeSlug%',
                    __( 'Previous name', 'wsal-woocommerce' ) => '%OldName%',
                ],
                [],
                'woocommerce-store',
                'modified',
            ],
            [
                9061,
                WSAL_LOW,
                __( 'User changed the default sort order of an attribute', 'wsal-woocommerce' ),
                __( 'Changed the Default Sorting Order of the attribute %AttributeName% in WooCommerce to %NewSortOrder%.', 'wsal-woocommerce' ),
                [
                    __( 'Attribute slug', 'wsal-woocommerce' ) => '%AttributeSlug%',
                    __( 'Previous sorting order', 'wsal-woocommerce' ) => '%OldSortOrder%',
                ],
                [],
                'woocommerce-store',
                'modified',
            ],
            [
                9062,
                WSAL_LOW,
                __( 'User enabled/disabled the option Enable Archives of an attribute', 'wsal-woocommerce' ),
                __( 'Changed the status of the option Enable Archives in WooCommerce attribute %AttributeName%.', 'wsal-woocommerce' ),
                [
                    __( 'Attribute slug', 'wsal-woocommerce' ) => '%Slug%',
                ],
                [],
                'woocommerce-store',
                'enabled',
            ],
        ],

        __( 'Coupons', 'wsal-woocommerce' )          => [
            [
                9063,
                WSAL_LOW,
                __( 'User published a new coupon', 'wsal-woocommerce' ),
                __( 'Created the WooCommerce coupon: %CouponName%.', 'wsal-woocommerce' ),
                [],
                [
                    __( 'View coupon in editor', 'wsal-woocommerce' ) => '%EditorLinkCoupon%',
                ],
                'woocommerce-coupon',
                'published',
            ],
            [
                9064,
                WSAL_LOW,
                __( 'User changed the discount type of a coupon', 'wsal-woocommerce' ),
                __( 'Changed the Discount Type in the coupon %CouponName% to %NewDiscountType%.%', 'wsal-woocommerce' ),
                [
                    __( 'Previous discount type', 'wsal-woocommerce' ) => '%OldDiscountType%',
                ],
                [
                    '%EditorLinkCoupon%',
                ],
                'woocommerce-coupon',
                'modified',
            ],
            [
                9065,
                WSAL_LOW,
                __( 'User changed the coupon amount of a coupon', 'wsal-woocommerce' ),
                __( 'Changed the Coupon amount in the coupon %CouponName% to %NewAmount%.', 'wsal-woocommerce' ),
                [
                    __( 'Previous amount', 'wsal-woocommerce' ) => '%OldAmount%',
                ],
                [
                    __( 'View coupon in editor', 'wsal-woocommerce' ) => '%EditorLinkCoupon%',
                ],
                'woocommerce-coupon',
                'modified',
            ],
            [
                9066,
                WSAL_LOW,
                __( 'User changed the coupon expire date of a coupon', 'wsal-woocommerce' ),
                __( 'Changed the expire date of the coupon %CouponName% to %NewDate%.', 'wsal-woocommerce' ),
                [
                    __( 'Previous date', 'wsal-woocommerce' ) => '%OldDate%',
                ],
                [
                    __( 'View coupon in editor', 'wsal-woocommerce' ) => '%EditorLinkCoupon%',
                ],
                'woocommerce-coupon',
                'modified',
            ],
            [
                9067,
                WSAL_LOW,
                __( 'User changed the usage restriction settings of a coupon', 'wsal-woocommerce' ),
                __( 'Changed the <strong>Usage restriction</strong> of the coupon %CouponName% to %NewMetaValue%.', 'wsal-woocommerce' ),
                [
                    __( 'Usage restriction parameter', 'wsal-woocommerce' ) => '%MetaKey%',
                    __( 'Previous value', 'wsal-woocommerce' ) => '%OldMetaValue%',
                ],
                [
                    __( 'View coupon in editor', 'wsal-woocommerce' ) => '%EditorLinkCoupon%',
                ],
                'woocommerce-coupon',
                'modified',
            ],
            [
                9068,
                WSAL_LOW,
                __( 'User changed the usage limits settings of a coupon', 'wsal-woocommerce' ),
                __( 'Change the <strong>Usage limits</strong> of the coupon %CouponName% to %NewMetaValue%.', 'wsal-woocommerce' ),
                [
                    __( 'Previous usage limits', 'wsal-woocommerce' ) => '%OldMetaValue%',
                ],
                [
                    __( 'View coupon in editor', 'wsal-woocommerce' ) => '%EditorLinkCoupon%',
                ],
                'woocommerce-store',
                'modified',
            ],
            [
                9069,
                WSAL_INFORMATIONAL,
                __( 'User changed the description of a coupon', 'wsal-woocommerce' ),
                __( 'Changed the description of the coupon %CouponName%.', 'wsal-woocommerce' ),
                [
                    __( 'Previous description', 'wsal-woocommerce' ) => '%OldDescription%',
                    __( 'New description', 'wsal-woocommerce' ) => '%NewDescription%',
                ],
                [
                    __( 'View coupon in editor', 'wsal-woocommerce' ) => '%EditorLinkCoupon%',
                ],
                'woocommerce-coupon',
                'modified',
            ],
            [
                9070,
                E_WARNING,
                __( 'User changed the status of a coupon', 'wsal-woocommerce' ),
                __( 'Changed the status of WooCommerce coupon %CouponName%', 'wsal-woocommerce' ),
                [
                    __( 'Old status', 'wsal-woocommerce' ) => '%OldStatus%',
                    __( 'New status', 'wsal-woocommerce' ) => '%NewStatus%',
                ],
                [],
                'woocommerce-coupon',
                'modified',
            ],
            [
                9071,
                WSAL_INFORMATIONAL,
                __( 'User renamed a WooCommerce coupon', 'wsal-woocommerce' ),
                __( 'Renamed the coupon %OldName% to %NewName%.', 'wsal-woocommerce' ),
                [],
                [
                    __( 'View coupon in editor', 'wsal-woocommerce' ) => '%EditorLinkCoupon%',
                ],
                'woocommerce-coupon',
                'renamed',
            ],
        ],

        __( 'Orders', 'wsal-woocommerce' )           => [
            [
                9035,
                WSAL_LOW,
                __( 'A WooCommerce order has been placed', 'wsal-woocommerce' ),
                __( 'A new order has been placed.', 'wsal-woocommerce' ),
                [
                    __( 'Order name', 'wsal-woocommerce' ) => '%OrderTitle%',
                ],
                [
                    __( 'View order', 'wsal-woocommerce' ) => '%EditorLinkOrder%',
                ],
                'woocommerce-order',
                'created',
            ],
            [
                9036,
                WSAL_INFORMATIONAL,
                __( 'WooCommerce order status changed', 'wsal-woocommerce' ),
                __( 'Marked the order %OrderTitle% as %OrderStatus%.', 'wsal-woocommerce' ),
                [],
                [
                    __( 'View order', 'wsal-woocommerce' ) => '%EditorLinkOrder%',
                ],
                'woocommerce-order',
                'modified',
            ],
            [
                9037,
                WSAL_MEDIUM,
                __( 'User moved a WooCommerce order to trash', 'wsal-woocommerce' ),
                __( 'Moved the order %OrderTitle% to trash', 'wsal-woocommerce' ),
                [],
                [
                    __( 'View order', 'wsal-woocommerce' ) => '%EditorLinkOrder%',
                ],
                'woocommerce-order',
                'deleted',
            ],
            [
                9038,
                WSAL_LOW,
                __( 'User moved a WooCommerce order out of trash', 'wsal-woocommerce' ),
                __( 'Restored the order %OrderTitle% out of the trash.', 'wsal-woocommerce' ),
                [],
                [
                    __( 'View order', 'wsal-woocommerce' ) => '%EditorLinkOrder%',
                ],
                'woocommerce-order',
                'restored',
            ],
            [
                9039,
                WSAL_LOW,
                __( 'User permanently deleted a WooCommerce order', 'wsal-woocommerce' ),
                __( 'Permanently deleted the order %OrderTitle%.', 'wsal-woocommerce' ),
                [],
                [],
                'woocommerce-order',
                'deleted',
            ],
            [
                9040,
                WSAL_MEDIUM,
                __( 'User edited a WooCommerce order', 'wsal-woocommerce' ),
                __( 'Changed the details in order %OrderTitle%.', 'wsal-woocommerce' ),
                [],
                [
                    __( 'View order', 'wsal-woocommerce' ) => '%EditorLinkOrder%',
                ],
                'woocommerce-order',
                'modified',
            ],
            [
                9041,
                WSAL_HIGH,
                __( 'User refunded a WooCommerce order', 'wsal-woocommerce' ),
                __( 'Refunded the order %OrderTitle%.', 'wsal-woocommerce' ),
                [],
                [
                    __( 'View order', 'wsal-woocommerce' ) => '%EditorLinkOrder%',
                ],
                'woocommerce-order',
                'modified',
            ],
            [
                9120,
                WSAL_HIGH,
                __( 'User added/removed a product from an order', 'wsal-woocommerce' ),
                __( 'The product %ProductTitle% to/from the order %OrderTitle%.', 'wsal-woocommerce' ),
                [],
                [
                    __( 'View order', 'wsal-woocommerce' ) => '%EditorLinkOrder%',
                ],
                'woocommerce-order',
                'added',
            ],
        ],

        __( 'User Profile', 'wsal-woocommerce' )     => [
            [
                9083,
                WSAL_INFORMATIONAL,
                __( 'User changed the billing address details', 'wsal-woocommerce' ),
                __( 'Changed <strong>billing address</strong> details of the user %TargetUsername%', 'wsal-woocommerce' ),
                [
                    __( 'Role', 'wsal-woocommerce' ) => '%Roles%',
                    __( 'Previous billing address', 'wsal-woocommerce' ) => '%OldValue%',
                    __( 'New Billing address', 'wsal-woocommerce' ) => '%NewValue%',
                ],
                [
                    __( 'User profile page', 'wsal-woocommerce' ) => '%EditUserLink%',
                ],
                'user',
                'modified',
            ],
            [
                9084,
                WSAL_INFORMATIONAL,
                __( 'User changed the shipping address details', 'wsal-woocommerce' ),
                __( 'Changed the <strong>shipping address</strong> details of the user %TargetUsername%', 'wsal-woocommerce' ),
                [
                    __( 'Role', 'wsal-woocommerce' ) => '%Roles%',
                    __( 'Previous shipping address', 'wsal-woocommerce' ) => '%OldValue%',
                    __( 'New Shipping address', 'wsal-woocommerce' ) => '%NewValue%',
                ],
                [
                    __( 'User profile page', 'wsal-woocommerce' ) => '%EditUserLink%',
                ],
                'user',
                'modified',
            ],
        ],
    ],
];
