# WP Data Access

* Contributors: [PeterSchulzNL](https://wpdataaccess.com/)
* Donate link: https://www.paypal.me/kpsch
* Requires at least: WordPress 4.8.3
* Tested up to: WordPress 5.8
* Stable tag: 4.3.0
* License: GPLv2 or later
* License URI: http://www.gnu.org/licenses/gpl-2.0.html

Local and remote data administration, publication and app development tool available directly from the WordPress dashboard.

## Description

WP Data Access is a powerful data administration, publication and development tool that allows you to perform database related tasks from your WordPress dashboard. An intuitive user interface helps to create fully responsive publications and data administration pages. No programming skills required!

For advanced users, the plugin support more complex features like remote database access, master-detail pages, lookups, WordPress role integration, WordPress user integration and a layer around your WordPress database which allows you to add database table and view specific functionality like dynamic hyperlinks and WordPress media library integration.

### Data Explorer
> Data and database administration

* Manage local and remote databases
* Database administration (rename, copy, drop, truncate...)
* Data administration (search, insert, update, delete...)
* Export to SQL, XML, JSON, CSV and Excel
* Import SQL and CSV files
* WordPress Media Library integration
* Inline editing (PREMIUM)
* Full-text search (PREMIUM)
* Individual column search (PREMIUM)
* Static hyperlinks
* Dynamic hyperlinks

### Query Builder
> Execute SQL statements from your WordPress dashboard

* Execute any SQL command (DCL, DDL, DML) - user must have the necessary privileges
* Only available for admin users
* Work on multiple SQL queries simultaneously (using tabs)
* Allows to access local and remote databases
* Queries can be saved and reused (saved per WordPress user account)
* Protects WordPress table structures (no DROP, ALTER and TRUNCATE allowed - not configurable)
* Protects WordPress table data (can be disabled for INSERT, UPDATE and DELETE)

### Data Publisher
> Publish responsive tables

* Responsive HTML tables
* Supports local and remote databases
* WordPress Media Library integration
* Static and dynamic hyperlink integration
* Easy level: no coding skills required
* Advanced level: JSON configuration
* Expert level: add JavaScript functions
* Export to CSV, Excel, PDF and SQL (PREMIUM)
* Print publication (PREMIUM)
* Copy publication to clipboard (PREMIUM)
* Individual column search (PREMIUM)
* Full-text search (PREMIUM)

### Data Projects
> Write your own WordPress apps

* Supports local and remote databases
* Auto generated CRUD pages
* Auto generate parent-child pages
* WordPress role integration
* WordPress media library integration
* Statis and dynamic hyperlink integration
* Accessible from the WordPress dashboard
* Add to webpage with shortcode wpdadiehard (FREE)
* Add to webpage with shortcode wpdadataprojects (PREMIUM)
* Add to webpage with shortcode wpdadataforms (PREMIUM)
* Inline editing (PREMIUM)
* Full-text search (PREMIUM)
* Individual column search (PREMIUM)

### Data Forms (PREMIUM)
> State of the art responsive data apps

* Turns a Data Project into a responsive data app
* Uses jQuery DataTables to generate list tables
* Uses AngularJS to generate data entry forms
* Uses jQuery UI for styling

### Geolocation (PREMIUM)
> Turn your database table into searchable map

* Use Google Maps key per table
* Define map settings per table
* Editing dynamic marker layout
* Batch procedure to store latitude and longitude
* Use static or user location
* Shortcode to add map to web page (+parameters)
* Search map within adjustable radius

### Data Designer
> Create tables and indexes

* Create and alter tables and indexes
* Supports reverse engineering and reconciliation

### Plugin Settings
> Manage plugin behaviour, style and security

* Many detailed plugin settings
* User access and permission
* Integrated WordPress role management

### Sources

[» Plugin Website](https://wpdataaccess.com/)
[» Download plugin](https://wordpress.org/plugins/wp-data-access/) 
[» What's New](https://wpdataaccess.com/docs/documentation/updates/whats-new/)
[» Documentation](https://wpdataaccess.com/docs/documentation/)

## License

WP Data Access is licensed under the [GPL v2](http://www.gnu.org/licenses/gpl-2.0.html) or later.

> This program is free software; you can redistribute it and/or modify
it under the terms of the GNU General Public License, version 2, as
published by the Free Software Foundation.

> This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

> You should have received a copy of the GNU General Public License
along with this program; if not, write to the Free Software
Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
